/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.storage;

import codechicken.enderstorage.api.AbstractEnderStorage;
import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.config.EnderStorageConfig;
import codechicken.enderstorage.container.ContainerEnderItemStorage;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.network.EnderStorageSPH;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.util.ArrayUtils;
import codechicken.lib.util.ServerUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class EnderItemStorage
extends AbstractEnderStorage
implements Container {
    public static final EnderStorageManager.StorageType<EnderItemStorage> TYPE = new EnderStorageManager.StorageType("item");
    public static final int[] sizes = new int[]{9, 27, 54};
    private ItemStack[] items;
    private int open;
    private int size = EnderStorageConfig.storageSize;

    public EnderItemStorage(EnderStorageManager manager, Frequency freq) {
        super(manager, freq);
        this.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearStorage() {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            this.empty();
            this.setDirty();
        }
    }

    @Override
    public void loadFromTag(CompoundTag tag) {
        this.size = tag.m_128445_("size");
        this.empty();
        InventoryUtils.readItemStacksFromTag((ItemStack[])this.items, (ListTag)tag.m_128437_("Items", 10));
        if (this.size != EnderStorageConfig.storageSize) {
            this.alignSize();
        }
    }

    private void alignSize() {
        if (EnderStorageConfig.storageSize > this.size) {
            ItemStack[] newItems = (ItemStack[])ArrayUtils.fill((Object[])new ItemStack[sizes[EnderStorageConfig.storageSize]], (Object)ItemStack.f_41583_);
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
            this.size = EnderStorageConfig.storageSize;
            this.m_6596_();
        } else {
            int numStacks = 0;
            for (ItemStack item : this.items) {
                if (item.m_41619_()) continue;
                ++numStacks;
            }
            if (numStacks <= sizes[EnderStorageConfig.storageSize]) {
                ItemStack[] newItems = (ItemStack[])ArrayUtils.fill((Object[])new ItemStack[sizes[EnderStorageConfig.storageSize]], (Object)ItemStack.f_41583_);
                int copyTo = 0;
                for (ItemStack item : this.items) {
                    if (item.m_41619_()) continue;
                    newItems[copyTo] = item;
                    ++copyTo;
                }
                this.items = newItems;
                this.size = EnderStorageConfig.storageSize;
                this.m_6596_();
            }
        }
    }

    @Override
    public String type() {
        return "item";
    }

    @Override
    public CompoundTag saveToTag() {
        if (this.size != EnderStorageConfig.storageSize && this.open == 0) {
            this.alignSize();
        }
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("Items", (Tag)InventoryUtils.writeItemStacksToTag((ItemStack[])this.items));
        compound.m_128344_("size", (byte)this.size);
        return compound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack m_8020_(int slot) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            return this.items[slot];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack m_8016_(int slot) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            return InventoryUtils.removeStackFromSlot((Container)this, (int)slot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_6836_(int slot, ItemStack stack) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            this.items[slot] = stack;
            this.m_6596_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openInventory() {
        if (this.manager.client) {
            return;
        }
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            ++this.open;
            if (this.open == 1) {
                EnderStorageSPH.sendOpenUpdateTo(null, this.freq, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeInventory() {
        if (this.manager.client) {
            return;
        }
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            --this.open;
            if (this.open == 0) {
                EnderStorageSPH.sendOpenUpdateTo(null, this.freq, false);
            }
        }
    }

    public int getNumOpen() {
        return this.open;
    }

    public int m_6643_() {
        return sizes[this.size];
    }

    public boolean m_7983_() {
        return ArrayUtils.count((Object[])this.items, stack -> !stack.m_41619_()) <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack m_7407_(int slot, int size) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            return InventoryUtils.decrStackSize((Container)this, (int)slot, (int)size);
        }
    }

    public int m_6893_() {
        return 64;
    }

    public void m_6596_() {
        this.setDirty();
    }

    public boolean m_6542_(Player var1) {
        return true;
    }

    public void empty() {
        this.items = new ItemStack[this.m_6643_()];
        ArrayUtils.fill((Object[])this.items, (Object)ItemStack.f_41583_);
    }

    public void openContainer(ServerPlayer player, Component title) {
        ServerUtils.openContainer((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((id, inv, p) -> new ContainerEnderItemStorage(id, inv, this), title), packet -> {
            this.freq.writeToPacket((MCDataOutput)packet);
            packet.writeByte(this.size);
        });
    }

    public void handleContainerPacket(MCDataInput packet) {
        this.size = packet.readByte();
        this.empty();
    }

    public int getSize() {
        return this.size;
    }

    public int openCount() {
        return this.open;
    }

    public void setClientOpen(int i) {
        if (this.manager.client) {
            this.open = i;
        }
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return true;
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public void m_6211_() {
    }
}

